// Tab list //

function TabList(x, y, w, style)
{
	if (!this instanceof TabList)
	return new TabList(x, y, w, style);
	
	this.x = x;
	this.y = y;
	this.style = style || new Style();
	this.index = 0;
	this.tabColUp = Colors.white;
	this.tabColDown = Colors.red;
	this.items = [];
	this.tabWidth = w;
}

// For useage see: Rad_ListBox.js for details //
TabList.prototype.populate = function(value, property)
{
	var tabWidth = this.tabWidth;
	function CreateTab(text)
	{
		return {text: text, width: tabWidth};
	}

	if (typeof value == 'object')
	{
		if (value.length != undefined) // hackish way to identify if the value is an array //
		{
			for (var i in value)
			{
				if (typeof value[i] == 'object')
				{
					if (typeof value[i][property] == 'function') Abort("Sorry: A function is an invalid property for a value in the ListBox object.", "Rad_ListBox.js", 19);
					this.items.push(CreateTab(value[i][property]));
				}
				else if(typeof value[i] != 'function') this.items.push(CreateTab(value[i]));
			}
		}
		else this.items.push(CreateTab(value[property]));
	}
	else if (typeof value != 'function') this.items.push(value);
	else Abort("Sorry: A function is an invalid value for the ListBox object.", "Rad_Listbox.js", 19);
}

TabList.prototype.blit = function()
{
	for (var i = 0; i < this.items.length; ++i)
	{
		if (this.index == i) this.style.window.setColorMask(this.tabColDown);
		else this.style.window.setColorMask(this.tabColUp);
		this.style.window.drawWindow(this.x + i * (this.tabWidth+24), this.y, this.items[i].width, this.style.font.getHeight());
		this.style.drawText(this.x + i * (this.tabWidth+24), this.y, this.items[i].text);
	}
	this.style.window.setColorMask(Colors.white);
}

// will add 1 to the index //
TabList.prototype.increment = function()
{
	if (this.index < this.items.length-1) this.index++;
}

// will minus 1 from the index //
TabList.prototype.decrement = function()
{
	if (this.index > 0) this.index--;
}
